import { Component, Input } from '@angular/core';
import { SideNavigationService } from '../../services/side-navigation-service';
import { BookmarkServices } from '../../services/bookmark-services';
import { SystemServices } from '../../services/system-services';

import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../store';
import { 
  DISABLE_CONCEPT_CARD_VIEW,
  ENABLE_CONCEPT_CARD_VIEW,
  ENABLE_CONCEPT_NODE_VIEW,
  DISABLE_CONCEPT_NODE_VIEW,
  BOOKMARK_ICON_FOCUSED,
  BOOKMARK_ICON_UNFOCUSED,
  SEARCH_ICON_FOCUSED,
  SEARCH_ICON_UNFOCUSED, 
} from '../../actions';

@Component({
  selector: 'app-side-navigation',
  templateUrl: './side-navigation.component.html',
  styleUrls: ['./side-navigation.component.scss']
})
export class SideNavigationComponent {
  @Input() bookmarks;
  @select(['system', 'focusedElement']) focusedElement;
  @select(['sideNavigation', 'isSearchIconFocus']) isSearchIconFocus;
  @select(['sideNavigation', 'isBookmarkIconFocus']) isBookmarkIconFocus;
  @select(['sideNavigation', 'activeIcon']) activeIcon;

  snService: SideNavigationService;
  constructor(
    snService: SideNavigationService,
    private bookmarkServices: BookmarkServices,
    private systemServices: SystemServices,
    private ngRedux: NgRedux<IAppState>) {
     this.snService = snService;
  }

  getState() {
    return this.ngRedux.getState();
  }

  getBookmarkCounts() {
    this.bookmarkServices.getCount();
  }

  setActive(type) {
    // if (type === this.getActive()) {
    //   this.disableActive();
    // } else {
    //   this.snService.setActiveIcon(type);
    // }
    this.snService.setActiveIcon(type);
    switch(type) {
      case 'conceptSearchIcon':
        this.systemServices.focusOn('searchInputField');
      break;
      case 'bookmarkListIcon':
        if (this.getState().bookmark.bookmarks != null && this.getState().bookmark.bookmarks.length > 0) {
          this.systemServices.focusOn('bookmarkLink' + this.getState().bookmark.bookmarks[0].bookmarkId);
        } else {
          this.systemServices.focusOn(type);
        }
      break;
      case 'dataElementListIcon':
        if (this.getState().concepts.dataElements != null && this.getState().concepts.dataElements.length > 0) {
          this.systemServices.focusOn('dataElementLink' + this.getState().concepts.dataElements[0].uri);
        } else {
          this.systemServices.focusOn(type);
        }
      break;
    }
  }

  getActive() {
    return this.snService.getActiveIcon();
  }

  disableActive() {
    this.snService.disableActiveIcon('conceptSearchIcon');
  }

  stringIsActive(type) {
    return type === this.getActive() ? 'expanded' : 'not expanded';
  }

  getBookmarkCountMessage() {
    // this needs to be updated in app mvp
    return this.getState().bookmark.bookmarks.length + ' bookmarks';
  }

  // isSearchIconFocus() {
  //   return this.getState().sideNavigation.isSearchIconFocus;
  // }

  // isBookmarkIconFocus() {
  //   return this.getState().sideNavigation.isBookmarkIconFocus;
  // }
}
